<?php

declare(strict_types=1);

namespace Drupal\brightcove\EventSubscriber;

use Brightcove\API\ApiClient;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Drupal\Core\Extension\ModuleExtensionList;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to kernel request event.
 */
final readonly class KernelRequestSubscriber implements EventSubscriberInterface {

  /**
   * Initializes an kernel request event subscriber.
   *
   * @param \Drupal\Core\Extension\ModuleExtensionList $moduleExtensionList
   *   Module extension list.
   */
  public function __construct(
    private ModuleExtensionList $moduleExtensionList,
  ) {
  }

  /**
   * Kernel request handler.
   *
   * @param \Symfony\Component\HttpKernel\Event\RequestEvent $event
   *   Response event.
   */
  public function onKernelRequest(RequestEvent $event): void {
    ApiClient::setConsumer('Drupal/' . \Drupal::VERSION . ' Brightcove/' . ($this->moduleExtensionList->getExtensionInfo('brightcove')['version'] ?: 'dev'));
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::REQUEST => 'onKernelRequest',
    ];
  }

}
