<?php

declare(strict_types=1);

namespace Drupal\brightcove;

use Brightcove\Item\Playlist as BrightcoveAPIWrapperPlaylist;

/**
 * Override Brightcove API Wrapper's Playlist class.
 */
class Playlist extends BrightcoveAPIWrapperPlaylist {

  /**
   * Override patch request to be able to alter the fields.
   */
  public function patchJson(): array {
    $data = parent::patchJSON();

    // Remove fields which are not needed to be sent to Brightcove.
    if (isset($data['id'])) {
      unset($data['id']);
    }

    return $data;
  }

}
