<?php

declare(strict_types=1);

namespace Drupal\brightcove\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Defines constraint for BrightcoveVideo referenced entity by API client.
 */
#[Constraint(
  id: 'brightcove_video_by_api_client_constraint',
  label: new TranslatableMarkup('Brightcove video constraint.', options: ['context' => 'Validation']),
)]
class VideoByApiClientConstraint extends SymfonyConstraint {

  /**
   * Error message for missing API client ID.
   */
  public string $missingApiClient = "API client ID is missing.";

}
