<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\API\ApiClientInterface as BrightcoveApiClientInterface;
use Drupal\brightcove\Entity\ApiClientInterface;
use Drupal\brightcove\Type\ApiClientStatus;

/**
 * Interface for an API client handler service.
 */
interface ApiClientHandlerInterface {

  /**
   * Gets an initialized API client.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client configuration.
   * @param bool $reconnect
   *   Whether to initialize the connection again or use the existing one.
   *
   * @return \Brightcove\API\ApiClientInterface
   *   Initialized API client.
   */
  public function getClient(ApiClientInterface $api_client, bool $reconnect = FALSE): BrightcoveApiClientInterface;

  /**
   * Tests connection.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client configuration.
   *
   * @return \Drupal\brightcove\Type\ApiClientStatus
   *   API client status.
   */
  public function testConnection(ApiClientInterface $api_client): ApiClientStatus;

}
