<?php

namespace Drupal\brightcove\Services;

use Brightcove\API\CmsInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * Interface of a CMS API handler.
 */
interface CmsApiHandlerInterface {

  /**
   * Gets the initialized CMS API for the given API client.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client.
   *
   * @return \Brightcove\API\CMS
   *   Initialized CMS API.
   */
  public function getApi(ApiClientInterface $api_client): CmsInterface;

}
