<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\API\IngestProfiles;
use Brightcove\API\IngestProfilesInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * Handler for Ingest Profiles API.
 */
final class IngestProfilesApiHandler implements IngestProfilesApiHandlerInterface {

  /**
   * Initialized Ingest Profiles APIs.
   *
   * @var \Brightcove\API\IngestProfilesInterface[]
   */
  private static array $apis = [];

  /**
   * Initializes an Ingest Profiles API handler.
   *
   * @param \Drupal\brightcove\Services\ApiClientHandlerInterface $apiClientHandler
   *   API client handler.
   */
  public function __construct(
    private readonly ApiClientHandlerInterface $apiClientHandler,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function getApi(ApiClientInterface $api_client): IngestProfilesInterface {
    $api_client_id = $api_client->id();
    if (isset(self::$apis[$api_client_id])) {
      return self::$apis[$api_client_id];
    }

    self::$apis[$api_client_id] = new IngestProfiles($this->apiClientHandler->getClient($api_client), $api_client->getAccountId());
    return self::$apis[$api_client_id];
  }

}
