<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\API\IngestProfilesInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * Interface of an Ingest Profiles API.
 */
interface IngestProfilesApiHandlerInterface {

  /**
   * Gets the initialized Ingest Profiles API for the given API client.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client.
   *
   * @return \Brightcove\API\IngestProfilesInterface
   *   Initialized Ingest Profiles API.
   */
  public function getApi(ApiClientInterface $api_client): IngestProfilesInterface;

}
