<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\Storage\StorageInterface;
use Drupal\brightcove\Entity\ApiClientInterface;
use Drupal\brightcove\LibraryStorage;
use Drupal\Core\KeyValueStore\KeyValueStoreExpirableInterface;

/**
 * Factory for library storage.
 */
final readonly class LibraryStorageFactory implements LibraryStorageFactoryInterface {

  /**
   * Initializes a library storage factory.
   *
   * @param \Drupal\Core\KeyValueStore\KeyValueStoreExpirableInterface $expirableKeyValueStorage
   *   Modified expirable key-value storage.
   */
  public function __construct(
    private KeyValueStoreExpirableInterface $expirableKeyValueStorage,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function get(ApiClientInterface $api_client): StorageInterface {
    return new LibraryStorage($api_client, $this->expirableKeyValueStorage);
  }

}
