<?php

namespace Drupal\brightcove\Services;

use Brightcove\Storage\StorageInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * Interface for a library storage factory.
 */
interface LibraryStorageFactoryInterface {

  /**
   * Gets an initialized library storage.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client.
   *
   * @return \Brightcove\Storage\StorageInterface
   *   An initialized library storage.
   */
  public function get(ApiClientInterface $api_client): StorageInterface;

}
