<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\Item\Playlist;

/**
 * Interface for a playlist helper.
 */
interface PlaylistHelperInterface extends VideoPlaylistHelperBaseInterface {

  /**
   * Create or update an existing playlist from a Brightcove Playlist object.
   *
   * @param \Brightcove\Item\Playlist $brightcove_playlist
   *   Brightcove Playlist object.
   * @param string $api_client_id
   *   The ID of the BrightcoveAPIClient entity.
   *
   * @throws \Exception
   *   If BrightcoveAPIClient ID is missing when a new entity is being created.
   */
  public function createOrUpdate(Playlist $brightcove_playlist, string $api_client_id): void;

}
