<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\API\PM;
use Brightcove\API\PmInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * PM API handler service.
 */
final class PmApiHandler implements PmApiHandlerInterface {

  /**
   * Initialized PM APIs.
   *
   * @var \Brightcove\API\PmInterface[]
   */
  private static array $apis = [];

  /**
   * Initializes an CMS API handler.
   *
   * @param \Drupal\brightcove\Services\ApiClientHandlerInterface $apiClientHandler
   *   API client handler.
   * @param \Drupal\brightcove\Services\ExpirableAccessTokenStorage $expirableAccessTokenStorage
   *   Expirable access token storage.
   */
  public function __construct(
    private readonly ApiClientHandlerInterface $apiClientHandler,
    private readonly ExpirableAccessTokenStorage $expirableAccessTokenStorage,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function getApi(ApiClientInterface $api_client): PmInterface {
    $api_client_id = $api_client->id();

    // Create new \Brightcove\API\CMS object if it is not exists yet.
    if (!isset(self::$apis[$api_client_id]) || !$this->expirableAccessTokenStorage->has($api_client->getClientId())) {
      self::$apis[$api_client_id] = new PM($this->apiClientHandler->getClient($api_client), $api_client->getAccountId());
    }

    return self::$apis[$api_client_id];
  }

}
