<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\API\PmInterface;
use Drupal\brightcove\Entity\ApiClientInterface;

/**
 * Interface of a PM API handler.
 */
interface PmApiHandlerInterface {

  /**
   * Gets the initialized PM API for the given API client.
   *
   * @param \Drupal\brightcove\Entity\ApiClientInterface $api_client
   *   API client.
   *
   * @return \Brightcove\API\PM
   *   Initialized PM API.
   */
  public function getApi(ApiClientInterface $api_client): PmInterface;

}
