<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Services;

use Brightcove\Item\Video\Video;
use Drupal\brightcove\Entity\VideoInterface;

/**
 * Interface for a video helper.
 */
interface VideoHelperInterface extends VideoPlaylistHelperBaseInterface {

  /**
   * Create or update a video.
   *
   * @param \Brightcove\Item\Video\Video $brightcove_video
   *   Brightcove video.
   * @param string|null $api_client_id
   *   API client ID.
   *
   * @return \Drupal\brightcove\Entity\VideoInterface
   *   The created or updated video.
   */
  public function createOrUpdate(Video $brightcove_video, ?string $api_client_id = NULL): VideoInterface;

  /**
   * Queues text tracks from the given video.
   *
   * @param \Drupal\brightcove\Entity\VideoInterface $video
   *   Drupal video.
   * @param \Brightcove\Item\Video\Video $brightcove_video
   *   Brightcove video.
   */
  public function queueTextTracks(VideoInterface $video, Video $brightcove_video): void;

}
