<?php

namespace Drupal\brightcove\Services;

use Drupal\brightcove\VideoPlaylistCmsEntityInterface;

/**
 * Interface for a video, playlist helper.
 */
interface VideoPlaylistHelperBaseInterface {

  /**
   * Helper function to save or update tags.
   *
   * @param \Drupal\brightcove\VideoPlaylistCmsEntityInterface $entity
   *   Video or playlist entity.
   * @param string $api_client_id
   *   API Client ID.
   * @param array $tags
   *   The list of tags from Brightcove.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function saveOrUpdateTags(VideoPlaylistCmsEntityInterface $entity, string $api_client_id, array $tags = []): void;

}
