<?php

declare(strict_types = 1);

namespace Drupal\brightcove\Type;

/**
 * DTO for API client status.
 */
final class ApiClientStatus {

  /**
   * Initializes an API client status DTO.
   *
   * @param \Drupal\brightcove\Type\ApiClientStatusType $status
   *   API client status type.
   * @param string $message
   *   Status message.
   */
  public function __construct(
    public readonly ApiClientStatusType $status,
    public readonly string $message = '',
  ) {
  }

}
