<?php

declare(strict_types=1);

namespace Drupal\brightcove;

use Brightcove\Item\Video\Video as BrightcoveVideo;

/**
 * Override Brightcove API Wrapper's Video class.
 */
class Video extends BrightcoveVideo {

  /**
   * Override patch request to be able to alter the fields.
   *
   * @return mixed[]
   *   Request return data.
   */
  public function patchJson(): array {
    $data = parent::patchJSON();

    // Remove fields which are not needed to be sent to Brightcove.
    if (isset($data['account_id'])) {
      unset($data['account_id']);
    }
    if (isset($data['id'])) {
      unset($data['id']);
    }

    return $data;
  }

}
