<?php

namespace Drupal\browsersync\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Browsersync settings form related functionality.
 */
class SettingsForm {

  /**
   * Form submission handler for theme settings form.
   *
   * @see browsersync_form_system_theme_settings_alter()
   */
  public static function submitForm(array &$form, FormStateInterface $form_state): void {
    $args = $form_state->getBuildInfo()['args'];
    $theme_key = !empty($args[0]) ? $args[0] : NULL;

    if ($theme_key) {
      $config_key = $theme_key . '.settings';
    }
    else {
      $config_key = 'system.theme.global';
    }

    $user_input = $form_state->getUserInput();

    \Drupal::configFactory()->getEditable($config_key)
      ->set('third_party_settings.browsersync.enabled', $user_input['browsersync_enabled'])
      ->set('third_party_settings.browsersync.host', $user_input['browsersync_host'])
      ->set('third_party_settings.browsersync.port', $user_input['browsersync_port'])
      ->save();
  }

}
