<?php

declare(strict_types=1);

namespace Drupal\bsky;

use potibm\Bluesky\Feed\Post;
use potibm\Bluesky\Response\RecordResponse;

/**
 * Post messages to BlueSky
 */
interface PostServiceInterface {

  /**
   * Create a post.
   *
   * @param string $message
   *   The message to send in the post.
   *
   * @return Post
   *   Post object to send to BlueSky.
   */
  public function createPost(string $message): Post;

  /**
   * Add an image to the post.
   *
   * @param Post $post
   *   The Post object.
   * @param string $path
   *   Path of the image to add -- usually starting with public://.
   * @param string $alt_text
   *   Alt text for the image.
   *
   * @return Post
   */
  public function addImage(Post $post, string $path, string $alt_text): Post;

  /**
   * Add a website card to the post.
   *
   * @param Post $post
   *   The Post object.
   * @param string $url
   *   URL to send in the card.
   * @param string $title
   *   Title to send in the card.
   * @param string $description
   *   Description for the card.
   * @param string|null $imagePath
   *   Optional image to include in the card.
   *
   * @return Post
   */
  public function addCard(Post $post, string $url, string $title, string $description, string $imagePath = null): Post;

  /**
   * Add BlueSky facets -- links, handles, and hashtags.
   *
   * @param Post $post
   *   The Post object.
   *
   * @return Post
   */
  public function addFacets(Post $post): Post;

  /**
   * @param Post $post
   *   The Post object.
   *
   * @return RecordResponse
   */
  public function sendPost(Post $post): RecordResponse;

}
