Bulk Image Regeneration (Drupal 10/11)
======================================

Overview
--------
Bulk Image Regeneration provides an administrative UI to regenerate image style derivatives for existing image files that are referenced by content. It supports dry-run mode, batching, and diagnostic messaging to help you understand what will be processed.

Requirements
------------
- Drupal core: ^10 or ^11
- Image module enabled (core)

Installation
------------
- Place this module in `web/modules/custom/bulk_image_regeneration` (or your preferred custom modules directory).
- Enable the module:
  - Admin UI: Extend → search for “Bulk Image Regeneration” → Enable
  - Drush: `drush en bulk_image_regeneration -y`

Permissions
-----------
- `administer bulk image regeneration`
  - Grants access to the admin form and processing.

Configuration / Where to find it
--------------------------------
- Admin path: `/admin/config/media/bulk-image-regeneration`
- Menu: Configuration → Media → Bulk Image Regeneration

How it works
------------
1. Image Styles to Regenerate
   - Choose one or more image styles. Only styles with actual effects are processed; empty styles are skipped.
2. Content Fields
   - The module scans configuration to list image fields (e.g., `Node: article - Hero image (field_hero)`).
   - Select at least one field. The module finds file entities referenced by the chosen fields and regenerates derivatives for those files.
3. Batch Size
   - Controls how many images are handled per batch operation. Larger batches are faster but may increase memory/timeout risk.
4. Dry Run
   - When enabled, the module reports what would be processed without writing any derivatives.
5. Handle Orphaned Files
   - Defines how to treat files that exist on disk but are missing corresponding file entities (skip, create entity, or delete). Only available when Dry Run is off.

User messages and logging
-------------------------
- The form reports counts for processed, skipped, missing, or relocated files.
- Detailed logs are written to the Drupal log (dblog/watchdog). Check at `/admin/reports/dblog`.

Routing and access
------------------
- Admin form route: `bulk_image_regeneration.admin_form` → `/admin/config/media/bulk-image-regeneration`
- Processing/health endpoint: `bulk_image_regeneration.batch_process` → `/admin/config/media/bulk-image-regeneration/process`
- Access is restricted by the `administer bulk image regeneration` permission.

Troubleshooting
---------------
- No Content Fields listed:
  - Confirm you have image fields configured.
  - Clear caches: `drush cr`.
- Nothing gets processed:
  - Ensure selected fields actually reference permanent file entities (temporary files are skipped).
  - Verify that selected image styles have effects.
  - Check file schemes (e.g., `public://` vs `private://`) and that originals exist on disk.
- Timeouts/Performance:
  - Reduce batch size.
  - Select fewer image styles at once.

Scope and limitations
---------------------
- Targets images referenced by configured image fields (does not crawl the entire filesystem).
- Skips temporary files and handles missing or orphaned records conservatively.
- If storage paths changed historically, the module attempts common alternative locations and logs any relocations detected.

Uninstall
---------
- Disable the module:
  - Admin UI or `drush pmu bulk_image_regeneration -y`
  - No content entities are created by this module; it only reads existing references and (optionally) writes derivatives.

License
-------
MIT or project default (update as appropriate).

Maintainers
-----------
- xpdientUK (GitHub) — `https://github.com/xpdientUK/bulk_image_regeneration`


