<?php

namespace Drupal\rabbitmq\Exception;

/**
 * Used when a worker plugin id does not match an existing plugin.
 */
class InvalidWorkerException extends \Exception {

  /**
   * InvalidWorkerException constructor.
   *
   * @param string $message
   *   The message.
   * @param int $code
   *   The code.
   * @param \Throwable|null $previous
   *   The previous exception to use in stack trace.
   */
  public function __construct(
    $message = '',
    $code = 0,
    ?\Throwable $previous = NULL
  ) {
    if (empty($message)) {
      $message = 'Queue worker does not implement the worker interface.';
    }
    parent::__construct($message, $code, $previous);
  }

}
