# Bunny - RabbitMQ integration for Drupal

## INTRODUCTION


## REQUIREMENTS

* RabbitMQ server needs to be installed and configured.
* Drupal must be configured with `php-amqplib`  
    * go to the root directory of your site
    * edit `composer.json` (not `core/composer.json`)
    * insert `"php-amqplib/php-amqplib": "^3.1"` in the `require` section of 
      the file.
    * Optional, but recommended: insert `"ext-pcntl": "*"` in the `require` 
      section of the file. Ensure your PHP actually includes that standard
      extension. Without it, the timeout mechanism for the consumer service will
      not be available.
    * Save it.
    * update your `vendor` directory by typing `composer update`.

## INSTALLATION

* Provide connection credentials as part of the `$settings` global variable in 
  `settings.local.php` (see the `example.settings.local.php` provided)

        $settings['bunny_credentials']['default'] = [
          'host' => 'localhost',
          'port' => 5672,
          'vhost' => '/',
          'username' => 'guest',
          'password' => 'guest',
        ];

## CONFIGURATION

* Configure Bunny as the queueing system for the queues you want RabbitMQ to
  maintain, either as the default queue service, default reliable queue service,
  or specifically for each queue:
    * If you want to set Bunny as the default queue manager, then add the 
      following to your settings.

          $settings['queue_default'] = 'queue.bunny.default';
    * Alternatively you can also set for each queue to use Bunny using one 
      of these formats:

          $settings['queue_service_{queue_name}'] = 'queue.bunny.default';
          $settings['queue_reliable_service_{queue_name}'] = 'queue.bunny.default';


## CUSTOMIZATION

Modules may override queue or exchange defaults built in a custom module by 
implementing `config/install/bunny.config.yml`. See 
`src/Queue/QueueBase.php` and `tests/src/kernel/BunnyTestBase::setUp()` for details.

## SSL

It is similar to the normal connection array, but you need to add 2 extra array 
keys.

This is an example of how `settings.php` should look like:

```php
// Certs should be stored outside the webroot.
define('CERTS_PATH', realpath(__DIR__ . '/../../../certs'));

$settings['bunny_credentials']['default'] = [
  'host' => 'host',
  'port' => 5672,
  'vhost' => '/',
  'username' => 'guest',
  'password' => 'guest',
  'ssl' => [
    'cafile' => CERTS_PATH . '/ca_certificate.pem',
    'local_cert' => CERTS_PATH . '/client_certificate.pem',
    'local_pk' => CERTS_PATH . '/client_key.pem',
    'verify_peer' => true,
    'verify_peer_name' => true,
  ],
  'options' => [
    'connection_timeout' => 20,
    'read_write_timeout' => 20,
  ],
];
```

## UPGRADING FROM 1.X

### Namespace Change
Version 1.x was a fork of `drupal/rabbitmq:3.x`. To provide a seamless migration the `rabbitmq` namespace was preserved.  The 2.x release migrates the code into the `bunny` namespace.

#### Credentials
`$settings['rabbitmq_credentials]` is now deprecated and should be migrated to `$settings['bunny_credentials]`. The new configuration key may be set prior to or after upgrading to 2.x. After upgrade to 2.x the `$settings['rabbitmq_credentials]` key may be removed.

#### Queues
The `queue.rabbitmq.*` queues are deprecated having been replaced by `queue.bunny.*`.  The 2.x release will continue to provide these queues for compatibility however `settings.php` and all custom code should be updated to utilize the new queue names as soon as possible after deploying 2.x.

### Configurable serializers
The default model of data serialization has changed in 1.x. PHP is now the
default serializer in 2.x.

If you upgraded to 1.0.1 (or newer) prior to upgrading to 2.x the serializer for existing configured queues will have been configured to JSON by the 1.0.1 update scripts.

The serialization may be changed by configuring
```bunny.queue.QUEUE_NAME.serializer``` for each queue.

In order to prevent issues after upgrading with Drupal Queues:

#### EMPTY EXISTING QUEUES

  * Prior to upgrading ensure that new messages will not be injected into the
    Queue.
    * Placing the site in Maintenance Mode will help prevent Drupal from
      injecting messages.
    * External processes should be disabled.
  * Process all remaining items in the queue either by executing CRON until
    all queues are empty or utilizing `drush rabbitmq:worker <queue_name>`
  * Upgrade the module to 2.x
  * Disable maintenance mode.

#### ALTERNATIVES FOR A QueueWorker:
A `QueueWorker` may be modified to continue using JSON by
implementing DecoderAwareWorkerInterface with json_decode() as the
configured decoder. If this change is done prior to upgrading the module
these queues do not need to be empty prior to upgrading to 2.x.

## INSTRUCTIONS FOR RUNNING TESTS

Test execution requires a RabbitMq server to be available at the host
`rabbitmq` with credentials `guest:guest`.

* An example to execute tests with RabbitMQ via Docker:
  * Prepare the Drupal install to run PHPUnit Tests. See
    [Running PHPUnit tests](https://www.drupal.org/docs/automated-testing/phpunit-in-drupal/running-phpunit-tests):
  * Add `127.0.0.1 rabbitmq` to `/etc/hosts`
  * Start RabbitMQ:
    `docker run -p 5672:5672 -d --hostname rabbitmq --name rabbitmq_rabbitmq --rm rabbitmq:3`
  * Run tests as normal:
    `SIMPLETEST_DB=sqlite://sites/default/files/.sqlite vendor/bin/phpunit -c web/core web/modules/contrib/bunny/tests/`
