<?php

/**
 * @file
 * Example settings to connect to RabbitMQ.
 *
 * This is the default data to add to your settings.local.php.
 */

$settings['bunny_credentials']['default'] = [
  'host' => 'localhost',
  'port' => 5672,
  'vhost' => '/',
  'username' => 'guest',
  'password' => 'guest',
  // Uncomment the lines below if you are using AMQP over SSL.
  /*
  'ssl' => [
    'cafile' => CERTS_PATH . '/ca_certificate.pem',
    'local_cert' => CERTS_PATH . '/client_certificate.pem',
    'local_pk' => CERTS_PATH . '/client_key.pem',
    'verify_peer' => true,
    'verify_peer_name' => true,
  ],
   */
  'options' => [
    'connection_timeout' => 5,
    'read_write_timeout' => 5,
  ],
];

$settings['queue_default'] = 'queue.bunny.default';

/**
 * Define a secondary connection by following the example below.
 *
 * Each connection will be assigned a dynamic service name based
 * on the key used to define it.
 *
 * @code
 * $settings['bunny_credentials']['qa'] = [
 *   'host' => 'http://qa-rabbitmq-host.com',
 *   'port' => 5672,
 *   'vhost' => '/',
 *   'username' => 'qa',
 *   'password' => 'qa',
 *   'options' => [
 *     'connection_timeout' => 15,
 *     'read_write_timeout' => 5,
 *   ],
 * ];
 *
 * $settings['queue_service_qa'] = 'queue.bunny.qa';
 * @endcode
 *
 * Queues that use the default `queue.bunny.default` service will use
 * the default connection.
*/
