<?php

namespace Drupal\Tests\bunny\Kernel;

use PhpAmqpLib\Message\AMQPMessage;

/**
 * Validate connection to the RabbitMq server.
 *
 * @group bunny
 */
class BunnyConnectionTest extends BunnyTestBase {

  /**
   * Test creating an item on an un-managed queue.
   */
  public function testCreateItemOnUnManagedQueue(): void {
    /** @var \PhpAmqpLib\Channel\AMQPChannel $channel */
    [$channel] = $this->initChannel($this->queueName);

    $count = 10;
    for ($i = 1; $i <= $count; $i++) {
      $payload = 'foo' . $i;
      $message = new AMQPMessage($payload);
      $channel->basic_publish($message, '', $this->routingKey);
    }

    $actual = FALSE;
    $received = 0;
    $callback = function (AMQPMessage $message) use (&$actual, &$received) {
      $actual = $message->getBody();
      $received++;
    };
    $channel->basic_consume($this->queueName,
      /* $consumer_tag = */ 'test',
      /* $no_local = */ FALSE,
      /* $no_ack = */ TRUE,
      /* $exclusive = */ FALSE,
      /* $nowait = */ FALSE,
      $callback
      // Defaulted args: ticket, arguments.
    );
    while (count($channel->callbacks) && $received < $count) {
      $channel->wait();
    }
    $this->assertEquals($actual, 'foo' . $count);
  }

}
