<?php

declare(strict_types=1);

namespace Drupal\Tests\bunny\Unit;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\MockObject\MockObject;

require_once __DIR__ . '/../../../../bunny.install';

/**
 * Tests bunny_update_100202()
 *
 * @group bunny
 *
 * @covers ::\bunny_update_100202()
 */
class Update100202Test extends UnitTestCase {

  /**
   * The ConfigFactory mock.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface&\PHPUnit\Framework\MockObject\MockObject
   */
  protected ConfigFactoryInterface&MockObject $configFactoryMock;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->configFactoryMock = $this->getConfigFactoryStub(
      [
        'bunny.config' => [
          'queues' => [
            'queue_json' => [
              'name' => 'queue_json',
              'serializer' => 'bunny.serialization.json',
            ],
            'queue_php' => [
              'name' => 'queue_php',
              'serializer' => 'bunny.serialization.phpserialize',
            ],
            'queue_no_serializer' => [
              'name' => 'queue_no_serializer',
            ],
          ],
        ],
      ]
    );

    $container = new ContainerBuilder();
    $container->set('config.factory', $this->configFactoryMock);
    \Drupal::setContainer($container);
  }

  /**
   * Test default serializer set.
   */
  public function testUpdate100302(): void {
    /** @var \Drupal\Core\Config\Config&MockObject $config */
    $config = $this->configFactoryMock->getEditable('bunny.config');
    $config
      ->expects($this->once())
      ->method('set')
      ->with(
        'queues',
        [
          'queue_json' => [
            'name' => 'queue_json',
            'serializer' => 'bunny.serialization.json',
          ],
          'queue_php' => [
            'name' => 'queue_php',
            'serializer' => 'bunny.serialization.phpserialize',
          ],
          'queue_no_serializer' => [
            'name' => 'queue_no_serializer',
            'serializer' => 'bunny.serialization.phpserialize',
          ],
        ],
      );
    $config->expects($this->once())->method('save');

    bunny_update_100202();
  }

}
