<?php

namespace Drupal\bunny_optimizer\Plugin\ImageEffect;

use Drupal\Core\Form\FormStateInterface;
use Drupal\image\Plugin\ImageEffect\ConvertImageEffect as CoreConvertImageEffect;

/**
 * Converts an image resource.
 */
class ConvertImageEffect extends CoreConvertImageEffect {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $messages = [];
    $messages['warning'][] = $this->t("Image conversion is not possible when using the Bunny Optimizer toolkit. Only WebP conversion is possible, but is handled on the CDN side, controlled by the 'WebP image compression' setting.");

    $form['extension']['#disabled'] = TRUE;
    $form['about'] = [
      '#theme' => 'status_messages',
      '#message_list' => $messages,
      '#status_headings' => [
        'status' => t('Status message'),
        'error' => t('Error message'),
        'warning' => t('Warning message'),
        'info' => t('Information message'),
      ],
      '#weight' => -10,
    ];

    return $form;
  }

}
