<?php

namespace Drupal\bunny_optimizer\Plugin\ImageEffect;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Image\ImageInterface;
use Drupal\image\ConfigurableImageEffectBase;

/**
 * An image effect to control the output quality of lossy file formats.
 *
 * @ImageEffect(
 *   id = "bunny_optimizer_quality",
 *   label = @Translation("Quality"),
 *   description = @Translation("Controls the output quality of lossy file formats"),
 * )
 */
class QualityImageEffect extends ConfigurableImageEffectBase {

  /**
   * {@inheritdoc}
   */
  public function applyEffect(ImageInterface $image): bool {
    return $image->apply('bunny_optimizer_param', [
      'key' => 'quality',
      'value' => $this->configuration['quality'],
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['quality'] = [
      '#type' => 'number',
      '#title' => 'Quality',
      '#description' => 'A number between 1 and 100.',
      '#default_value' => $this->configuration['quality'] ?? 80,
      '#required' => TRUE,
      '#min' => 1,
      '#max' => 100,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['quality'] = (int) $form_state->getValue('quality');
  }

  /**
   * {@inheritdoc}
   */
  public function getSummary(): array {
    $summary = parent::getSummary();
    $summary['#markup'] = $this->configuration['quality'];

    return $summary;
  }

}
