<?php

namespace Drupal\bunny_optimizer\Plugin\ImageToolkit\Operation;

use Drupal\Core\ImageToolkit\ImageToolkitOperationBase;

/**
 * Converts an image to a different format.
 *
 * @ImageToolkitOperation(
 *   id = "bunny_optimizer_convert",
 *   toolkit = "bunny_optimizer",
 *   operation = "convert",
 *   label = @Translation("Convert"),
 *   description = @Translation("Instructs the toolkit to save the image with a specified extension.")
 * )
 *
 * @method \Drupal\bunny_optimizer\Plugin\ImageToolkit\BunnyOptimizerToolkit getToolkit()
 */
class Convert extends ImageToolkitOperationBase {

  /**
   * {@inheritdoc}
   */
  protected function arguments(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  protected function execute(array $arguments): bool {
    // Nothing to do here, the conversion is handled on the CDN side.
    return TRUE;
  }

}
