<?php

namespace Drupal\bureauworks_tmgmt\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\Annotation\ViewsField;
use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;
use Drupal\Component\Utility\Html;

/**
 * Provides a Bureau Works Project Name field for Views.
 *
 * @ViewsField("bw_project_name")
 */
class BureauWorksProjectNameField extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {

    $fallback_value = [
      '#markup' => 'N/A',
    ];

    $entity = isset($values->_entity) ? $values->_entity : NULL;
    if (empty($entity) || !method_exists($entity, 'getRemoteMappings')) {
      return $fallback_value;
    }

    foreach ($entity->getRemoteMappings() as $remote_mapping) {
      $value = $remote_mapping->getRemoteIdentifier3();
      if (!empty($value)) {
        return [
          '#markup' => Html::escape($value),
        ];
      }
    }

    return $fallback_value;
  }
}
