<?php

namespace Drupal\bureauworks_tmgmt\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\tmgmt\Entity\JobItem;
use Drupal\tmgmt\JobItemInterface;

/**
 * Processes fetching logic for queue items for Bureau Works.
 *
 * @QueueWorker(
 *   id = "bureau_api.fetch_queue",
 *   title = @Translation("Bureau API Fetch Queue Worker"),
 *   cron = {"time" = 30}
 * )
 */
class BureauApiFetchQueueWorker extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    \Drupal::logger('bureau_api')->info('Processing "fetch queue" item. Data: <pre>@data</pre>', ['@data' => print_r($data, TRUE)]);

    $job_item_id = $data['job_item_id'] ?? NULL;
    if (!$job_item_id) {
      \Drupal::logger('bureau_api')->warning('Job item ID is missing. Skipping fetch...');
      return;
    }

    $job_item = JobItem::load($job_item_id);
    if (!$job_item) {
      \Drupal::logger('bureau_api')->error('Job item not found: [@id]. Skipping fetch...', ['@id' => $job_item_id]);
      return;
    }

    if ($job_item->getJob()->getTranslatorId() !== 'bwx') {
      return;
    }

    $this->import($job_item);
  }

  private function import(JobItemInterface $job_item) {
    $job = $job_item->getJob();
    $translator = $job->getTranslator();

    try {
        if ($translator->getPlugin() && method_exists($translator->getPlugin(), 'importAndCleanup')) {
          $translator->getPlugin()->importAndCleanup($job_item);
        } else {
          \Drupal::logger('bureau_api')->error('Translator plugin does not support importing and cleanup method.');
        }
    } catch (\Exception $e) {
      \Drupal::logger('bureau_api')->error('Error during requesting import for job item ID [@jid]: @message', [
        '@jid' => $job_item->id(),
        '@message' => $e->getMessage(),
      ]);

    }
  }

}
