<?php

namespace Drupal\bureauworks_tmgmt\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\Annotation\ViewsField;
use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;
use Drupal\Component\Utility\Html;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * Provides a Bureau Works Last Workflow Delivered field for Views.
 *
 * @ViewsField("bw_last_workflow_delivered")
 */
class BureauWorksLastWorkflowDeliveredField extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {

    $fallback_value = [
      '#markup' => 'N/A',
    ];
    
    $entity = isset($values->_entity) ? $values->_entity : NULL;
    if (empty($entity) || !method_exists($entity, 'getRemoteMappings')) {
      return $fallback_value;
    }

    foreach ($entity->getRemoteMappings() as $remote_mapping) {

        $last_delivered_workflow = $remote_mapping->getRemoteData("last_delivered_workflow");
        if (empty($last_delivered_workflow)) {
            continue;
        }

        $last_delivered_workflow_timestamp = $remote_mapping->getRemoteData("last_delivered_workflow_timestamp");

        $field_display_value = $last_delivered_workflow;

        // If timestamp exists, convert it into a human readable format.
        if (!empty($last_delivered_workflow_timestamp) && is_numeric($last_delivered_workflow_timestamp)) {
            $date = DrupalDateTime::createFromTimestamp(((int) $last_delivered_workflow_timestamp) / 1000);
            $formatted_date = $date->format('Y-m-d H:i:s');
            $field_display_value .= ' (Last fetched at: ' . $formatted_date . ')';
        }

        if (!empty($field_display_value)) {
            return [
              '#markup' => Html::escape($field_display_value),
            ];
        }

    }
    return $fallback_value;
  }
}
