<?php

declare(strict_types=1);

namespace Drupal\business_identity;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service provider for Business Identity module.
 */
class BusinessIdentityServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container): void {
    // Register token service.
    $container->register('business_identity.token', 'Drupal\business_identity\Token\BusinessIdentityToken')
      ->addArgument(new Reference('config.factory'))
      ->addTag('token_info');
  }

}
