/**
 * @file
 * JavaScript for Business Identity Opening Hours.
 */

(function ($, Drupal) {
  'use strict';

  /**
   * Toggle opening hours day visibility.
   */
  Drupal.behaviors.businessIdentityOpeningHours = {
    attach: function (context, settings) {
      // Toggle day containers based on open checkbox.
      $('.opening-hours-day input[type="checkbox"]', context).once('business-identity').each(function () {
        var $checkbox = $(this);
        var $container = $checkbox.closest('.opening-hours-day').find('.form-wrapper');

        function toggleDay() {
          if ($checkbox.is(':checked')) {
            $container.show();
          }
          else {
            $container.hide();
          }
        }

        // Initial state.
        toggleDay();

        // Bind change event.
        $checkbox.on('change', toggleDay);
      });
    }
  };

})(jQuery, Drupal);
