# Business Identity Local - Germany 🇩🇪

German local laws module for Business Identity.

## Features

- **USt-IdNr**: German VAT identification number for EU transactions
- **Commercial Register**: HRB/HRA numbers from local courts
- **VAT Information**: Domestic VAT numbers and regimes
- **Legal Notice (Impressum)**: Compliance with TMG §5 requirements
- **GDPR (DSGVO)**: German data protection compliance
- **E-Commerce**: AGB, withdrawal policies, dispute resolution
- **Industry Regulations**: Chamber memberships and certifications

## Key German Legal Requirements

### 1. USt-IdNr (VAT ID)
- Required for B2B transactions within EU
- Format: DE + 9 digits (DE123456789)
- Issued by Federal Central Tax Office (BZSt)

### 2. Impressum (Legal Notice)
Required by Telemedia Act (TMG) for:
- Commercial websites
- Regulated professions
- All businesses with German presence

### 3. DSGVO (GDPR)
- German implementation of EU GDPR
- Requires Data Protection Officer for certain organizations
- Strict privacy policy requirements

### 4. E-Commerce Regulations
- General Terms & Conditions (AGB)
- Right of withdrawal (Widerrufsrecht)
- Dispute resolution participation

## Installation

1. Copy the module to `/modules/custom/business_identity_local_de/`
2. Enable the module at `/admin/modules`
3. Configure German settings at `/admin/config/system/business-identity` in the "Local Laws" tab

## Usage

### Required Fields for German Operations:
1. **USt-IdNr**: For EU B2B transactions
2. **Impressum Information**: For website compliance
3. **VAT Details**: For domestic taxation

### Recommended Setup:
1. Enable "Impressum Required" if operating in Germany
2. Enter USt-IdNr if conducting EU B2B business
3. Configure GDPR compliance settings
4. Set up e-commerce URLs (AGB, Widerrufsrecht)

## Tokens Available

Use these tokens in content, blocks, and views:
- `[business:local_laws_de_ust_idnr]` - USt-IdNr without prefix
- `[business:local_laws_de_ust_idnr_full]` - Full USt-IdNr (DE + 9 digits)
- `[business:local_laws_de_handelsregisternummer]` - Commercial register number
- `[business:local_laws_de_datenschutzerklaerung_url]` - Privacy policy URL
- `[business:local_laws_de_agb_url]` - Terms & conditions URL
- `[business:local_laws_de_widerrufsrecht_url]` - Withdrawal policy URL

## Validation

The module validates:
- USt-IdNr format (9 digits with checksum)
- IBAN format (German IBAN: DE + 20 digits)
- BIC format (8 or 11 characters)
- URL formats for legal documents

## Dependencies
- Business Identity module

## Legal Notice

This module provides configuration fields for German legal requirements.
Always consult with a German legal professional (Rechtsanwalt) for compliance with German laws, especially:
- Telemedia Act (TMG)
- GDPR (DSGVO)
- Value Added Tax Act (UStG)
- Civil Code (BGB) for e-commerce

## Support

For issues or feature requests, please contact the module maintainer.
