# Business Identity Local - Italy 🇮🇹

Italian local laws module for Business Identity.

## Features

- **CIN (Codice Identificativo Nazionale)**: National identification code for Italian businesses
- **VAT (IVA) Configuration**: Partita IVA, VAT regime, and rates
- **Electronic Invoicing**: Fatturazione Elettronica settings with SDI Code
- **PEC Email**: Certified email for official communications
- **GDPR Compliance**: Italian Privacy Code (D.Lgs. 196/2003) compliance
- **Business Registry**: REA registration and ATECO codes

## Installation

1. Copy the module to `/modules/custom/business_identity_local_it/`
2. Enable the module at `/admin/modules`
3. Configure Italian settings at `/admin/config/system/business-identity` in the "Local Laws" tab

## Usage

### CIN (Codice Identificativo Nazionale)
The CIN is an 11-digit number that uniquely identifies Italian businesses for:
- Electronic invoicing
- Tax purposes
- Official communications with Agenzia delle Entrate

### Electronic Invoicing
Required for B2B and B2C transactions in Italy. You'll need:
1. Valid CIN
2. SDI Code (7 characters)
3. PEC email address

### Tokens Available
Use these tokens in content, blocks, and views:
- `[business:local_laws_it_cin]` - CIN without prefix
- `[business:local_laws_it_cin_full]` - Full CIN (IT + 11 digits)
- `[business:local_laws_it_iva_number]` - Partita IVA
- `[business:local_laws_it_sdi_code]` - SDI Code for e-invoicing
- `[business:local_laws_it_pec_email]` - PEC certified email

## Validation
The module validates:
- CIN format (11 digits with checksum)
- VAT number format and validity
- SDI Code format (7 uppercase alphanumeric characters)
- PEC email format

## Dependencies
- Business Identity module

## Legal Notice
This module provides configuration fields for Italian legal requirements.
Always consult with a legal professional for compliance with Italian laws.
