/**
 * @file
 * JavaScript for Italian local laws module.
 */

(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.businessIdentityLocalIT = {
    attach: function (context, settings) {
      // Auto-format CIN input
      $('input[data-cin-input]', context).once('cin-format').each(function () {
        $(this).on('input', function () {
          // Remove any non-digit characters
          var value = $(this).val().replace(/\D/g, '');

          // Limit to 11 digits
          if (value.length > 11) {
            value = value.substring(0, 11);
          }

          $(this).val(value);

          // Show validation feedback
          if (value.length === 11) {
            $(this).addClass('is-valid').removeClass('is-invalid');
          } else if (value.length > 0) {
            $(this).addClass('is-invalid').removeClass('is-valid');
          } else {
            $(this).removeClass('is-valid is-invalid');
          }
        });
      });

      // Auto-format VAT number
      $('input[data-drupal-selector*="iva-number"]', context).once('iva-format').each(function () {
        $(this).on('input', function () {
          var value = $(this).val().replace(/\D/g, '');

          if (value.length > 11) {
            value = value.substring(0, 11);
          }

          $(this).val(value);
        });
      });

      // Auto-uppercase SDI code
      $('input[data-drupal-selector*="sdi-code"]', context).once('sdi-uppercase').each(function () {
        $(this).on('input', function () {
          $(this).val($(this).val().toUpperCase());
        });
      });

      // Show/hide electronic invoicing fields based on CIN
      var $cinField = $('input[data-cin-input]', context);
      var $fatturazioneSection = $('fieldset[data-drupal-selector*="fatturazione-section"]', context);

      if ($cinField.length && $fatturazioneSection.length) {
        function toggleFatturazioneSection() {
          if ($cinField.val().length === 11) {
            $fatturazioneSection.slideDown();
          } else {
            $fatturazioneSection.slideUp();
          }
        }

        toggleFatturazioneSection();
        $cinField.on('input', toggleFatturazioneSection);
      }
    }
  };

})(jQuery, Drupal);
