<?php

namespace Drupal\cache_monitor\Cache;

use Drupal\cache_monitor\Metrics\MetricsGateTrait;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Cache\CacheFactoryInterface;
use Drupal\cache_monitor\Metrics\Aggregator;

/**
 * Decorates the cache factory and wraps each bin with the timing backend.
 */
class TimingCacheFactory implements CacheFactoryInterface {

  /**
   * The decorated cache factory.
   *
   * @var \Drupal\Core\Cache\CacheFactoryInterface
   */
  private CacheFactoryInterface $inner;

  /**
   * The metrics aggregator.
   *
   * @var \Drupal\cache_monitor\Metrics\Aggregator
   */
  private Aggregator $agg;

  /**
   * Constructs a new TimingCacheFactory instance.
   *
   * @param \Drupal\Core\Cache\CacheFactoryInterface $inner
   *   The decorated cache factory.
   * @param \Drupal\cache_monitor\Metrics\Aggregator $agg
   *   The metrics aggregator.
   */
  public function __construct(
    CacheFactoryInterface $inner,
    Aggregator $agg
  ) {
    $this->inner = $inner;
    $this->agg = $agg;
  }

  /**
   * {@inheritdoc}
   */
  public function get($bin): CacheBackendInterface {
    $backend = $this->inner->get($bin);
    return new TimingBackend($backend, (string) $bin, $this->agg);
  }
}

