<?php

namespace Drupal\cache_register\Object;

use Drupal\Core\Cache\CacheBackendInterface;

/**
 * Defines an interface for SlotBase.
 */
interface SlotBaseInterface {

  /**
   * Get the ID of the slot's cache entry.
   *
   * @return string
   *   The ID.
   */
  public function id(): string;

  /**
   * Gets the slots parent drawer.
   *
   * @return \Drupal\cache_register\Object\DrawerInterface
   *   The drawer.
   */
  public function getDrawer(): DrawerInterface;

  /**
   * Gets the slot's drawer's register.
   *
   * @return \Drupal\cache_register\Object\DrawerInterface|null
   *   The drawer.
   */
  public function getRegister(): ?RegisterInterface;

  /**
   * Gets the cache backend.
   *
   * @return \Drupal\Core\Cache\CacheBackendInterface
   *   The cache backend.
   */
  public function getCacheBackend(): CacheBackendInterface;

  /**
   * Checks if the slot has an entry in the cache.
   *
   * @return bool
   *   Whether or not the slot with the given ids is cached.
   */
  public function isCached(): bool;

  /**
   * Gets the slot's cache entry.
   *
   * @param bool $allow_invalid
   *   (optional) If TRUE, a cache item may be returned even if it is expired or
   *   has been invalidated. Such items may sometimes be preferred, if the
   *   alternative is recalculating the value stored in the cache, especially
   *   if another concurrent request is already recalculating the same value.
   *   The "valid" property of the returned object indicates whether the item is
   *   valid or not. Defaults to FALSE.
   *
   * @return object|null
   *   The cache item or NULL on failure.
   */
  public function getCache(bool $allow_invalid = FALSE): ?object;

  /**
   * Adds the given tags to the slot's cache entry.
   *
   * @param array|string $tags
   *   One or multiple tags to append to the item.
   *
   * @throws \Throwable
   *   If the cache hasn't been set.
   */
  public function addCacheTags($tags): void;

}
