CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * Usage
 * Permissions
 * Troubleshooting
 * Security Considerations
 * Maintainers

INTRODUCTION
------------

Cache Visualization (cacheviz) is a developer tool for visualizing and debugging
Drupal's render cache. It helps identify caching problems by displaying cache
metadata (tags, contexts, and max-age) directly on rendered page elements.

Key features:
 * Visual highlighting of uncacheable elements (max-age: 0)
 * Detection of per-user and session-based cache contexts
 * Interactive panel showing cache statistics and issues
 * Bubble chain tracing to find root causes of cache problems
 * Keyboard shortcuts for quick toggling

This module is intended for development and debugging purposes only. It should
not be enabled on production sites as it exposes cache metadata information.

REQUIREMENTS
------------

 * Drupal 11.x
 * PHP 8.3 or higher

INSTALLATION
------------

Install as you would normally install a contributed Drupal module. Visit
https://www.drupal.org/docs/extending-drupal/installing-drupal-modules for
further information.

CONFIGURATION
-------------

1. Navigate to Administration > Configuration > Development > Cacheviz
   (/admin/config/development/cacheviz)

2. Enable the module by checking "Enable Cacheviz"

3. Optionally enable "Auto-highlight problems on page load" to automatically
   highlight cache issues when pages load

4. Configure excluded paths where cache visualization should not appear
   (one path per line, wildcards supported):
   ```
   /admin
   /admin/*
   /user/login
   /user/register
   ```

5. Grant the "View Cacheviz debug information" permission to roles that should
   see the cache visualization

USAGE
-----

Once enabled and configured:

1. Visit any page while logged in with the appropriate permission

2. The Cacheviz panel appears in the bottom-right corner showing:
   - Page-level cache status (max-age, contexts, tags)
   - Elements breakdown (uncacheable, time-limited, permanent)
   - Cache variation statistics

3. Navigate between views:
   - **Overview**: Summary statistics and page cache status
   - **Issues**: Grouped issues by severity (critical, warning, info)
   - **Elements**: Searchable list of all tracked elements

4. Click "Locate" to scroll to and highlight specific elements

5. Click "Details" to see full cache metadata for an element

6. Use keyboard shortcuts:
   - `Ctrl+Shift+C`: Toggle panel visibility
   - `Ctrl+Shift+H`: Toggle element highlights

Understanding highlights:
 * **Red (Critical)**: Uncacheable elements (max-age: 0)
 * **Orange (Warning)**: Per-user or session cache contexts
 * **Purple (Limited)**: Time-limited cache
 * **Green (Permanent)**: Fully cacheable

PERMISSIONS
-----------

 * **View Cacheviz debug information**: Required to see cache visualization.
   Restricted permission - should only be granted to developers.

 * **Administer Cacheviz settings**: Required to configure module settings.
   Restricted permission - should only be granted to administrators.

TROUBLESHOOTING
---------------

**The panel does not appear**

 * Verify the module is enabled at /admin/config/development/cacheviz
 * Verify you have the "View Cacheviz debug information" permission
 * Check if the current path is in the excluded paths list
 * Clear the Drupal cache after making changes

**JavaScript errors in console**

 * Ensure the cacheviz.comments.js file loads before cacheviz.js
 * Check for JavaScript conflicts with other modules

**Elements not being tracked**

 * Only HTML elements with render cache metadata are tracked
 * Plain text content is not wrapped with cache comments
 * Some elements may be cached at a higher level

SECURITY CONSIDERATIONS
-----------------------

This module exposes internal cache metadata which could reveal information about
your site's architecture. Security measures implemented:

 * Permission-based access control (restricted permissions)
 * Path exclusion support for sensitive areas
 * No cache metadata exposed when module is disabled
 * All user-provided data (selectors, paths) is properly escaped

**Important**: This module should only be enabled on development or staging
environments. Do not enable on production sites.

MAINTAINERS
-----------
* lexsoft - https://www.drupal.org/u/lexsoft
This project is maintained by the Drupal community. For support, please use the
issue queue at https://www.drupal.org/project/issues/cacheviz
