<?php

declare(strict_types=1);

namespace Drupal\cacheviz\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Cacheviz settings.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'cacheviz_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['cacheviz.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('cacheviz.settings');

    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Cacheviz'),
      '#description' => $this->t('When disabled, no cache visualization occurs on any page.'),
      '#default_value' => $config->get('enabled'),
    ];

    $form['auto_highlight_problems'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Auto-highlight problems on page load'),
      '#description' => $this->t('Automatically highlight elements with caching problems when the page loads.'),
      '#default_value' => $config->get('auto_highlight_problems'),
    ];

    $form['excluded_paths'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Excluded paths'),
      '#description' => $this->t('Enter paths where cache visualization should be disabled, one per line. Use wildcards (*) for pattern matching. Examples: <code>/admin/*</code>, <code>/user/login</code>.'),
      '#default_value' => $config->get('excluded_paths'),
      '#rows' => 10,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('cacheviz.settings')
      ->set('enabled', (bool) $form_state->getValue('enabled'))
      ->set('auto_highlight_problems', (bool) $form_state->getValue('auto_highlight_problems'))
      ->set('excluded_paths', $form_state->getValue('excluded_paths'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
