# Calculator Field

A Drupal field type, widget, and formatter that computes values from other
fields using a simple tokenized math formula.

- Build formulas with tokens like `[field_price] * [field_quantity]`.
- See live results on the node edit form (no save required).
- Render the computed value on node view, with optional display of the formula
  and the field values used.

## Features
- Field type: `calculator_field` that stores a numeric result.
- Field widget: configure a formula per bundle via Manage form display.
  - Clickable tokens for eligible fields (integer, float, decimal,
    and date range if exposed).
- Live calculation on node edit forms via JavaScript (on load and on input
  change) without saving the node.
- Field formatter:
  - Computes on the fly at view time using the same formula.
  - Optional settings to show the formula and show the formula with current
    field values substituted.
  - Optional custom CSS classes for easy theming.

## Requirements / Dependencies
- Drupal core: 10 or 11
- Core Field UI
- Token module (declared via `.info.yml` and `composer.json`)

Composer dependency (already declared):
```
composer require drupal/token
```

## Installation
1. Place this module in your codebase, e.g. `web/modules/contrib/calculator_field`.
2. Install through Admin → Extend, or via Drush:
   - `drush en calculator_field -y`

## Configuration and Usage
1. Add the field
   - Structure → Content types → Manage fields → Add field → Calculator Field.
2. Configure form display
   - Structure → Content types → Manage form display → Edit the Calculator
     Widget settings.
   - Enter a formula using tokens, e.g. `[field_price] * [field_quantity]`.
   - Click on tokens listed to insert them into the formula.
3. Configure display (formatter)
   - Structure → Content types → Manage display.
   - Select “Calculator Formatter”.
   - Optional settings:
     - Show formula: renders the original formula string.
     - Show formula with values: renders the formula with current entity values
       substituted (e.g. `10.50 * 3`).
     - Custom CSS classes: space-separated classes added to the output wrapper.

### Eligible tokens
- By default, the token picker lists bundle fields of type `integer`, `float`,
  `decimal` (and can be extended to `date range`), excluding system/base fields
  like `nid`, `vid`, `uid`, `created`, `changed`, and the `calculator_field`
  itself (to avoid recursion).

### Example formulas
- Subtotal: `[field_price] * [field_quantity]`
- Total with tax: `([field_price] * [field_quantity]) * 1.18`
- Weighted value: `([field_a] * 0.3) + ([field_b] * 0.7)`

## Notes on evaluation
- The frontend uses JavaScript to update the result as you type on the edit
  form.
- The formatter sanitizes the expression on the server side and evaluates it to
  display the number at view time.
- If you require stricter evaluation, you can replace the evaluator with a
  dedicated math parser library.

## Theming / Styling
- Formatter output is wrapped in a container with class
  `calculator-field-output` and any custom classes you configure.
- Additional classes are applied to inner elements:
  - `.calculator-formula`
  - `.calculator-formula-values`
  - `.calculator-formula-field-list`
  - `.calculator-result`

## Troubleshooting
- Token list shows “no fields found for this bundle”:
  - Ensure you have eligible numeric fields on the bundle.
  - Clear caches: `drush cr`.
- Tokens do not insert into the formula:
  - Make sure you’re editing the widget settings on Manage form display.
  - Clear caches to refresh attached JS: `drush cr`.
- Custom widget/formatter not found (plugin errors):
  - Clear caches: `drush cr`.
  - Confirm the plugin annotations exist in the classes.

## Uninstallation
1. Remove or reassign Calculator Field from content types as needed.
2. Uninstall via Admin → Extend or Drush:
   - `drush pmu calculator_field -y`

## Security considerations
- Formula is configured by site builders/administrators, not end-users.
- Server-side evaluation is sanitized to allow only numeric/math characters.
  For stricter policies, use a dedicated math parser.

## Project information
- Short name: `calculator_field`
- Package (admin UI grouping): Field types
- Issue queue and support: create an issue on the project page on drupal.org.

## Maintainers
- Initial maintainer: Site implementer
- Contributions welcome via merge requests or issue queue on drupal.org.
