(function ($, Drupal, drupalSettings, once) {
  function compute(formula, tokens) {
    let calc = formula;
    (tokens || []).forEach(function (t) {
      const fName = t.replace(/\[|\]/g, '');
      const value = parseFloat($(`[name *= "${fName}"]`).val()) || 0;
      calc = (calc || '').split(t).join(value);
    });
    let result = 0;
    try {
      // eslint-disable-next-line no-eval
      result = eval(calc || '0');
      if (!isFinite(result)) { result = 0;
      }
    } catch (e) {
      result = 0;
    }
    return result;
  }

  Drupal.behaviors.calculatorField = {
    attach: function (context, settings) {
      const cfg = (drupalSettings && drupalSettings.calculator_field) || {};
      const tokens = cfg.tokens || [];
      const formula = cfg.formula || '';

      $(once('calculator-init', '.calculator-field-result', context)).each(function () {
        const initial = compute(formula, tokens);
        $(this).val(initial);
      });

      // Bind listeners to all token-provided fields.
      (tokens || []).forEach(function (token) {
        const fieldName = token.replace(/\[|\]/g, '');
        const selector = `[name *= "${fieldName}"]`;
        $(once('calculator-bind-' + fieldName, selector, context)).on('input change', function () {
          const val = compute(formula, tokens);
          $('.calculator-field-result', context).val(val);
        });
      });
    }
  };
})(jQuery, Drupal, drupalSettings, once);
