(function ($, Drupal, once) {
  function insertAtCursor($textarea, text) {
    const textarea = $textarea.get(0);
    if (!textarea) { return;
    }
    const start = textarea.selectionStart || 0;
    const end = textarea.selectionEnd || 0;
    const val = $textarea.val();
    const before = val.substring(0, start);
    const after = val.substring(end, val.length);
    $textarea.val(before + text + after);
    const cursor = start + text.length;
    textarea.selectionStart = textarea.selectionEnd = cursor;
    $textarea.trigger('input');
  }

  Drupal.behaviors.calculatorTokenSelector = {
    attach: function (context) {
      const $formula = $('.calculator-formula-input', context);
      $(once('calculator-token-buttons', '.calculator-token-button', context)).on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        const token = $(this).attr('data-token') || $(this).text();
        if (!token || !$formula.length) { return;
        }
        insertAtCursor($formula, ( $formula.val() ? ' ' : '' ) + token);
      });

      $(once('calculator-token-links', '.calculator-token-link', context)).on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        const token = $(this).attr('data-token') || $(this).text();
        if (!token || !$formula.length) { return;
        }
        insertAtCursor($formula, ( $formula.val() ? ' ' : '' ) + token);
      });
    }
  };
})(jQuery, Drupal, once);
