<?php

namespace Drupal\calculator_field\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'calculator_field' field type.
 *
 * @FieldType(
 *   id = "calculator_field",
 *   label = @Translation("Calculator Field"),
 *   description = @Translation("Stores calculated value."),
 *   default_widget = "calculator_widget",
 *   default_formatter = "calculator_formatter"
 * )
 */
class CalculatorFieldItem extends FieldItemBase {

  /**
   * Define field item properties.
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = [];

    // The calculated numeric result.
    $properties['value'] = DataDefinition::create('float')
      ->setLabel(t('Value'))
      ->setRequired(TRUE);

    return $properties;
  }

  /**
   * Database schema for field storage.
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'value' => [
          'type' => 'float',
          'not null' => FALSE,
        ],
      ],
    ];
  }

  /**
   * Check if the field item is empty.
   */
  public function isEmpty() {
    $value = $this->get('value')->getValue();
    return $value === NULL || $value === '';
  }

}
