<?php

declare(strict_types=1);

namespace Drupal\calendar_card_formatter\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'Random_default' formatter.
 *
 * @FieldFormatter(
 *   id = "calendar_card_formatter",
 *   label = @Translation("Calendar Card Formatter"),
 *   field_types = {
 *     "datetime"
 *   }
 * )
 */

class CalendarCardFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    $summary[] = $this->t('Display in format of: @foo', ['@foo' => $this->getSetting('date_option')]);
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings(): array {
    $setting = ['date_option' => 'd_m_y'];
    return $setting + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $form = parent::settingsForm($form, $form_state);

    $form['date_option'] = [
      '#title' => $this->t('Date Format'),
      '#type' => 'select',
      '#options' => [
        'day_month_year' => $this->t('Day Month Year'),
        'day_month' => $this->t('Day Month'),
        'month_year' => $this->t('Month Year'),
      ],
      '#default_value' => $this->getSetting('date_option'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $element = [];
    
    foreach ($items as $delta => $item) {
      $element[$delta] = [
        '#theme' => 'calendar_card_formatter', // Reference the theme hook
        '#value' => $item->value, // Pass data to the template
        '#format_value' => $this->getSetting('date_option'),
      ];
    }
    
    return $element;
  }

}
