<?php

/**
 * @file
 * Displays the email message form for one target.
 *
 * Available variables:
 * - $element: The form element as generated by the Email channel plugin.
 *
 * @see \Drupal\campaignion_email_to_target\Channel\Email::messageForm()
 *
 * @ingroup themeable
 */
?>
<?php echo render($element['send']); ?>
<?php if ($element['#editable']): ?>
  <?php echo render($element['subject']); ?>
<?php else: ?>
  <p class="form-label email-to-target-subject-title"><?php echo filter_xss_admin($element['subject']['#title']); ?></p>
  <p class="email-to-target-subject"><strong><?php echo check_plain($element['subject']['#default_value']); ?></strong></p>
<?php endif; ?>
<pre class="email-to-target-header"><?php echo render($element['header']); ?></pre>
<?php echo render($element['message']); ?>
<pre class="email-to-target-footer"><?php echo render($element['footer']); ?></pre>
