export default {
  'tokens': [
    {
      'title': 'Email-to-Target dataset: <em class=\'placeholder\'>MPs</em>',
      'description': 'Replace values based on the selected target(s).',
      'tokens': [
        {
          'token': '[target:constituency.name]',
          'title': 'Constituency name',
          'description': ''
        },
        {
          'token': '[target:constituency.country.code]',
          'title': 'Country code',
          'description': 'Country code (E, N, S or W)'
        },
        {
          'token': '[target:constituency.country.name]',
          'title': 'Country name',
          'description': 'Country name (ie. England)'
        }
      ]
    },
    {
      'title': 'Submission',
      'description': 'Tokens related to webform submissions.',
      'tokens': [
        {
          'token': '[submission:access-token]',
          'title': 'Access token',
          'description': 'The security token used to gain access to this webform submission.'
        },
        {
          'token': '[submission:confirm_url]',
          'title': 'Confirmation URL',
          'description': 'The URL in the email body generated by webform_confirm_email for the user to click and confirm his/her submissions.'
        },
        {
          'token': '[submission:completed_date]',
          'title': 'Date completed',
          'description': 'The date the webform was first completed (not draft).'
        }
      ]
    }
  ],
  'messageSelection': [
    {
      'id': null,
      'type': 'message',
      'label': '',
      'filters': [],
      'url': '',
      'urlLabel': '',
      'message': {
        'subject': '',
        'header': 'Dear [target:salutation],\n\n',
        'footer': '\n\nYours sincerely,\n[submission:values:first_name] [submission:values:last_name]\n[submission:values:street_address]\n[submission:values:postcode]',
        'body': ''
      }
    }
  ],
  'targetAttributes': [
    {
      'name': 'title',
      'label': 'Title',
      'description': ''
    },
    {
      'name': 'first_name',
      'label': 'First name',
      'description': ''
    },
    {
      'name': 'last_name',
      'label': 'Last name',
      'description': ''
    },
    {
      'name': 'email',
      'label': 'Email address',
      'description': ''
    },
    {
      'name': 'salutation',
      'label': 'Salutation',
      'description': 'Full name and titles'
    },
    {
      'name': 'political_affiliation',
      'label': 'Political Affiliation',
      'description': ''
    },
    {
      'name': 'constituency.name',
      'label': 'Constituency name',
      'description': ''
    },
    {
      'name': 'constituency.country.code',
      'label': 'Country code',
      'description': 'Country code (E, N, S or W)'
    },
    {
      'name': 'constituency.country.name',
      'label': 'Country name',
      'description': 'Country name (ie. England)'
    }
  ],
  'hardValidation': true,
  'endpoints': {
    'messages': '/node/8/email-to-target-messages',
    'nodes': '/wizard/nodes',
    'e2t-api': {
      'url': 'https://e2t-api.more-onion.com/v2',
      'token': process.env.E2T_API_TOKEN || 'xxx', // token injected by Vite
      'dataset': 'mp'
    }
  }
}
