import { IconButton, Tooltip } from '@radix-ui/themes';

import { useAppDispatch, useAppSelector } from '@/app/hooks';
import {
  selectAiPanelOpen,
  setAiPanelClosed,
  setAiPanelOpen,
} from '@/features/ui/primaryPanelSlice';

const AiToggleButton = () => {
  const isAiPanelOpen = useAppSelector(selectAiPanelOpen);
  const dispatch = useAppDispatch();

  function handleToggle() {
    if (isAiPanelOpen) {
      dispatch(setAiPanelClosed());
    } else {
      dispatch(setAiPanelOpen());
    }
  }

  const lineColor = isAiPanelOpen ? '#0090FF' : '#1C2024';
  return (
    <Tooltip content={isAiPanelOpen ? 'Close AI Panel' : 'Open AI Panel'}>
      <IconButton
        variant={isAiPanelOpen ? 'solid' : 'ghost'}
        size="1"
        onClick={handleToggle}
        aria-label={isAiPanelOpen ? 'Close AI Panel' : 'Open AI Panel'}
      >
        <svg
          width="25"
          height="24"
          viewBox="0 0 25 24"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <g clipPath="url(#clip0_713_7537)">
            <path
              d="M14.2576 19.1178C14.0565 19.1178 13.8801 18.9777 13.8295 18.7764L13.2818 16.6106C12.9265 15.2066 11.8619 14.1072 10.5025 13.7403L8.40532 13.1746C8.2104 13.1224 8.07471 12.9402 8.07471 12.7325C8.07471 12.5249 8.2104 12.3427 8.40532 12.2905L10.5025 11.7248C11.8619 11.3579 12.9265 10.2585 13.2818 8.85451L13.8295 6.68872C13.8801 6.48743 14.0565 6.34729 14.2576 6.34729C14.4587 6.34729 14.6351 6.48743 14.6857 6.68872L15.2334 8.85451C15.5887 10.2585 16.6533 11.3579 18.0127 11.7248L20.1099 12.2905C20.3048 12.3427 20.4405 12.5249 20.4405 12.7325C20.4405 12.9402 20.3048 13.1224 20.1099 13.1746L18.0127 13.7403C16.6533 14.1072 15.5887 15.2066 15.2334 16.6106L14.6857 18.7764C14.6351 18.9777 14.4587 19.1178 14.2576 19.1178Z"
              fill="white"
            />
            <path
              d="M14.2576 6.72826C14.2884 6.72826 14.318 6.74737 14.3279 6.78432L14.8756 8.95011C15.2654 10.4891 16.4287 11.6917 17.9202 12.0943L20.0173 12.66C20.0901 12.6791 20.0901 12.7861 20.0173 12.8052L17.9202 13.3709C16.43 13.7734 15.2654 14.9748 14.8756 16.5151L14.3279 18.6809C14.318 18.7178 14.2884 18.7369 14.2576 18.7369C14.2267 18.7369 14.1971 18.7178 14.1873 18.6809L13.6395 16.5151C13.2497 14.9761 12.0864 13.7734 10.595 13.3709L8.49782 12.8052C8.42503 12.7861 8.42503 12.6791 8.49782 12.66L10.595 12.0943C12.0852 11.6917 13.2497 10.4904 13.6395 8.95011L14.1873 6.78432C14.1971 6.74737 14.2267 6.72826 14.2576 6.72826ZM14.2576 5.96387C13.8875 5.96387 13.5643 6.22121 13.4705 6.59067L12.9228 8.75646C12.6021 10.0266 11.6374 11.0216 10.4075 11.3541L8.31031 11.9198C7.95256 12.0166 7.70337 12.3504 7.70337 12.7326C7.70337 13.1148 7.95256 13.4486 8.31031 13.5454L10.4075 14.1111C11.6374 14.4423 12.6008 15.4386 12.9228 16.7087L13.4705 18.8745C13.5643 19.244 13.8875 19.5013 14.2576 19.5013C14.6277 19.5013 14.9509 19.244 15.0446 18.8745L15.5923 16.7087C15.9131 15.4386 16.8778 14.4436 18.1077 14.1111L20.2048 13.5454C20.5626 13.4486 20.8118 13.1148 20.8118 12.7326C20.8118 12.3504 20.5626 12.0166 20.2048 11.9198L18.1077 11.3541C16.8778 11.0229 15.9143 10.0266 15.5923 8.75646L15.0446 6.59067C14.9509 6.22121 14.6277 5.96387 14.2576 5.96387Z"
              fill={lineColor}
            />
            <path
              d="M7.96115 10.6878C7.81558 10.6878 7.68358 10.5923 7.63301 10.4509L7.3283 9.58074C7.13586 9.03165 6.72136 8.60359 6.19091 8.40612L5.34958 8.09271C5.21142 8.04175 5.1189 7.90544 5.1189 7.75383C5.1189 7.60223 5.21142 7.46591 5.34958 7.41495L6.19091 7.10155C6.72136 6.9028 7.13709 6.47474 7.3283 5.92692L7.63177 5.05806C7.68235 4.91537 7.81311 4.81982 7.95991 4.81982C8.10671 4.81982 8.23871 4.91537 8.28806 5.05806L8.59153 5.92692C8.78397 6.47602 9.19846 6.90408 9.72892 7.10155L10.5702 7.41622C10.7084 7.46718 10.8009 7.6035 10.8009 7.75511C10.8009 7.90671 10.7084 8.04175 10.5715 8.09399L9.73015 8.40866C9.19846 8.60741 8.78397 9.03547 8.59276 9.58329L8.28929 10.4521C8.23995 10.5948 8.10795 10.6904 7.96115 10.6904V10.6878Z"
              fill="white"
            />
            <path
              d="M7.9612 5.137C7.97724 5.137 7.99328 5.14591 7.99944 5.16502L8.30415 6.03389C8.5262 6.66961 9.01101 7.17029 9.62658 7.39961L10.4679 7.71429C10.5037 7.72703 10.5037 7.77926 10.4679 7.792L9.62658 8.10668C9.01101 8.33599 8.5262 8.83667 8.30415 9.4724L7.99944 10.3413C7.99328 10.3591 7.97724 10.3693 7.9612 10.3693C7.94517 10.3693 7.92913 10.3604 7.92296 10.3413L7.61826 9.4724C7.39621 8.83667 6.91139 8.33599 6.29582 8.10668L5.45449 7.792C5.41872 7.77926 5.41872 7.72703 5.45449 7.71429L6.29582 7.39961C6.91139 7.17029 7.39621 6.66961 7.61826 6.03389L7.92296 5.16502C7.92913 5.14719 7.94517 5.137 7.9612 5.137ZM7.9612 4.5C7.68487 4.5 7.43692 4.67963 7.34316 4.94845L7.03846 5.81731C6.87809 6.27595 6.53021 6.63521 6.08611 6.80083L5.24478 7.11551C4.98572 7.21233 4.81055 7.46841 4.81055 7.75378C4.81055 8.03915 4.98449 8.29523 5.24478 8.39205L6.08611 8.70673C6.53021 8.87235 6.87809 9.23161 7.03846 9.69025L7.34316 10.5591C7.43692 10.8267 7.68487 11.0076 7.9612 11.0076C8.23753 11.0076 8.48549 10.8279 8.57924 10.5591L8.88395 9.69025C9.04432 9.23161 9.3922 8.87235 9.8363 8.70673L10.6776 8.39205C10.9367 8.29523 11.1119 8.03915 11.1119 7.75378C11.1119 7.46841 10.9379 7.21233 10.6776 7.11551L9.8363 6.80083C9.3922 6.63521 9.04432 6.27595 8.88395 5.81731L8.57924 4.94845C8.48549 4.68091 8.23753 4.5 7.9612 4.5Z"
              fill={lineColor}
            />
            <path
              d="M9.77089 18.8121C9.65739 18.8121 9.55624 18.7382 9.51799 18.6286L9.35639 18.1662C9.26264 17.8974 9.05909 17.6872 8.7988 17.5903L8.34976 17.4222C8.24367 17.3827 8.17212 17.2782 8.17212 17.1623C8.17212 17.0463 8.24367 16.9419 8.34853 16.9024L8.79756 16.7342C9.05786 16.6374 9.2614 16.4272 9.35516 16.1584L9.51799 15.6946C9.555 15.5863 9.65739 15.5125 9.76965 15.5125C9.88191 15.5125 9.98307 15.5863 10.0213 15.6946L10.1841 16.1584C10.2779 16.4272 10.4814 16.6374 10.7417 16.7342L11.1908 16.9024C11.2969 16.9419 11.3684 17.0463 11.3684 17.1623C11.3684 17.2782 11.2969 17.3839 11.1908 17.4234L10.7417 17.5903C10.4814 17.6872 10.2779 17.8974 10.1841 18.1662L10.0213 18.6299C9.98307 18.7395 9.88191 18.8134 9.76965 18.8134L9.77089 18.8121Z"
              fill="white"
            />
            <path
              d="M9.77092 15.7659C9.77955 15.7659 9.78819 15.771 9.79066 15.7812L9.95349 16.245C10.0719 16.5838 10.331 16.8514 10.6591 16.9737L11.1082 17.1419C11.1267 17.1495 11.1267 17.1763 11.1082 17.1839L10.6591 17.3521C10.331 17.4744 10.0719 17.7419 9.95349 18.0808L9.79066 18.5445C9.78695 18.5547 9.77832 18.5598 9.77092 18.5598C9.76352 18.5598 9.75365 18.5547 9.75118 18.5445L9.58834 18.0808C9.46992 17.7419 9.21086 17.4744 8.88271 17.3521L8.43368 17.1839C8.41517 17.1763 8.41517 17.1495 8.43368 17.1419L8.88271 16.9737C9.21086 16.8514 9.46992 16.5838 9.58834 16.245L9.75118 15.7812C9.75488 15.771 9.76352 15.7659 9.77092 15.7659ZM9.77092 15.2563C9.55503 15.2563 9.36012 15.3978 9.28611 15.608L9.12327 16.0717C9.05419 16.2692 8.90492 16.4233 8.71371 16.4947L8.26467 16.6628C8.06113 16.738 7.92419 16.9393 7.92419 17.1635C7.92419 17.3877 8.06113 17.5878 8.26467 17.6642L8.71371 17.8324C8.90492 17.9037 9.05419 18.0579 9.12327 18.2553L9.28611 18.7191C9.36012 18.9293 9.5538 19.0707 9.77092 19.0707C9.98803 19.0707 10.1817 18.9293 10.2557 18.7191L10.4186 18.2553C10.4876 18.0579 10.6369 17.9037 10.8281 17.8324L11.2772 17.6642C11.4807 17.5878 11.6176 17.3877 11.6176 17.1635C11.6176 16.9393 11.4807 16.7393 11.2772 16.6628L10.8281 16.4947C10.6369 16.4233 10.4876 16.2692 10.4186 16.0717L10.2557 15.608C10.1817 15.3978 9.98803 15.2563 9.77092 15.2563Z"
              fill={lineColor}
            />
          </g>
          <defs>
            <clipPath id="clip0_713_7537">
              <rect
                width="16"
                height="15"
                fill="white"
                transform="translate(4.81177 4.5)"
              />
            </clipPath>
          </defs>
        </svg>
      </IconButton>
    </Tooltip>
  );
};

export default AiToggleButton;
