import { getSiteData } from '@/lib/drupal-utils';

const Branding = () => {
  const { homeUrl, siteName } = getSiteData().branding;
  if (siteName === null) {
    return null;
  }
  return (
    <a href={homeUrl} aria-label={siteName} className="max-h-full">
      <LogoIcon />
      <div className="sr-only">{siteName}</div>
    </a>
  );
};

const LogoIcon = () => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="121"
    height="29"
    viewBox="0 0 121 29"
    fill="none"
  >
    <path
      d="M35.1708 28.2232V5.62584H39.9048V24.2841H49.5041V28.2232H35.1708Z"
      fill="#020617"
    />
    <path
      d="M72.4971 16.9245C72.4971 19.3888 72.0343 21.4852 71.1086 23.2139C70.1902 24.9425 68.9366 26.2629 67.3476 27.175C65.766 28.0798 63.9876 28.5322 62.0123 28.5322C60.0225 28.5322 58.2368 28.0761 56.6551 27.164C55.0735 26.2519 53.8235 24.9315 52.9051 23.2028C51.9867 21.4742 51.5275 19.3814 51.5275 16.9245C51.5275 14.4603 51.9867 12.3639 52.9051 10.6352C53.8235 8.90659 55.0735 7.58988 56.6551 6.6851C58.2368 5.77296 60.0225 5.31689 62.0123 5.31689C63.9876 5.31689 65.766 5.77296 67.3476 6.6851C68.9366 7.58988 70.1902 8.90659 71.1086 10.6352C72.0343 12.3639 72.4971 14.4603 72.4971 16.9245ZM67.6975 16.9245C67.6975 15.3283 67.4606 13.9822 66.9869 12.8861C66.5204 11.7901 65.8608 10.9589 65.008 10.3925C64.1552 9.82608 63.1566 9.54287 62.0123 9.54287C60.868 9.54287 59.8694 9.82608 59.0167 10.3925C58.1639 10.9589 57.5006 11.7901 57.0269 12.8861C56.5604 13.9822 56.3271 15.3283 56.3271 16.9245C56.3271 18.5208 56.5604 19.8669 57.0269 20.9629C57.5006 22.059 58.1639 22.8902 59.0167 23.4566C59.8694 24.023 60.868 24.3062 62.0123 24.3062C63.1566 24.3062 64.1552 24.023 65.008 23.4566C65.8608 22.8902 66.5204 22.059 66.9869 20.9629C67.4606 19.8669 67.6975 18.5208 67.6975 16.9245Z"
      fill="#020617"
    />
    <path
      d="M91.0049 12.9303C90.8518 12.3933 90.6368 11.9188 90.3598 11.5069C90.0829 11.0876 89.7439 10.7345 89.3431 10.4477C88.9495 10.1534 88.4976 9.92906 87.9874 9.77459C87.4844 9.62011 86.9269 9.54287 86.3146 9.54287C85.1703 9.54287 84.1644 9.82975 83.2971 10.4035C82.437 10.9773 81.7665 11.8122 81.2854 12.9082C80.8044 13.9969 80.5638 15.3283 80.5638 16.9025C80.5638 18.4766 80.8007 19.8154 81.2745 20.9188C81.7482 22.0222 82.4188 22.8645 83.2862 23.4456C84.1535 24.0193 85.1776 24.3062 86.3583 24.3062C87.4298 24.3062 88.3445 24.115 89.1025 23.7325C89.8678 23.3426 90.4509 22.7946 90.8518 22.0884C91.26 21.3822 91.4641 20.5473 91.4641 19.5837L92.4262 19.7272H86.6535V16.1301H96.0231V18.9768C96.0231 20.9629 95.6077 22.6695 94.7768 24.0966C93.9459 25.5163 92.8015 26.6123 91.3438 27.3847C89.8861 28.1497 88.217 28.5322 86.3365 28.5322C84.2373 28.5322 82.3933 28.0651 80.8044 27.1309C79.2154 26.1893 77.9763 24.8542 77.0871 23.1256C76.2052 21.3896 75.7642 19.3299 75.7642 16.9466C75.7642 15.115 76.0266 13.482 76.5514 12.0476C77.0835 10.6058 77.8269 9.38472 78.7817 8.38432C79.7366 7.38391 80.8481 6.62257 82.1163 6.1003C83.3846 5.57803 84.7585 5.31689 86.2381 5.31689C87.5063 5.31689 88.6871 5.50447 89.7804 5.87962C90.8737 6.24742 91.8431 6.76969 92.6886 7.44643C93.5413 8.12318 94.2374 8.92865 94.7768 9.86286C95.3161 10.7897 95.6624 11.8122 95.8154 12.9303H91.0049Z"
      fill="#020617"
    />
    <path
      d="M120.309 16.9245C120.309 19.3888 119.846 21.4852 118.921 23.2139C118.002 24.9425 116.749 26.2629 115.16 27.175C113.578 28.0798 111.799 28.5322 109.824 28.5322C107.834 28.5322 106.049 28.0761 104.467 27.164C102.885 26.2519 101.635 24.9315 100.717 23.2028C99.7987 21.4742 99.3395 19.3814 99.3395 16.9245C99.3395 14.4603 99.7987 12.3639 100.717 10.6352C101.635 8.90659 102.885 7.58988 104.467 6.6851C106.049 5.77296 107.834 5.31689 109.824 5.31689C111.799 5.31689 113.578 5.77296 115.16 6.6851C116.749 7.58988 118.002 8.90659 118.921 10.6352C119.846 12.3639 120.309 14.4603 120.309 16.9245ZM115.509 16.9245C115.509 15.3283 115.273 13.9822 114.799 12.8861C114.332 11.7901 113.673 10.9589 112.82 10.3925C111.967 9.82608 110.969 9.54287 109.824 9.54287C108.68 9.54287 107.681 9.82608 106.829 10.3925C105.976 10.9589 105.313 11.7901 104.839 12.8861C104.372 13.9822 104.139 15.3283 104.139 16.9245C104.139 18.5208 104.372 19.8669 104.839 20.9629C105.313 22.059 105.976 22.8902 106.829 23.4566C107.681 24.023 108.68 24.3062 109.824 24.3062C110.969 24.3062 111.967 24.023 112.82 23.4566C113.673 22.8902 114.332 22.059 114.799 20.9629C115.273 19.8669 115.509 18.5208 115.509 16.9245Z"
      fill="#020617"
    />
    <path
      fill-rule="evenodd"
      clip-rule="evenodd"
      d="M21.1663 4.01338C18.4741 4.01338 16.2917 6.21598 16.2917 8.93303C16.2917 11.6501 18.4741 13.8527 21.1663 13.8527C23.8586 13.8527 26.041 11.6501 26.041 8.93303C26.041 6.21598 23.8586 4.01338 21.1663 4.01338ZM21.1663 0.129456C16.3487 0.129456 12.4432 4.07095 12.4432 8.93303C12.4432 13.7951 16.3487 17.7366 21.1663 17.7366C25.984 17.7366 29.8895 13.7951 29.8895 8.93303C29.8895 4.07095 25.984 0.129455 21.1663 0.129456Z"
      fill="#2563EB"
    />
    <path
      d="M13.4553 5.4375C13.0713 6.4176 12.8603 7.48579 12.8603 8.6037C12.8603 8.88238 12.8734 9.15798 12.8991 9.42988H3.95589V25.0076H19.3912V16.9797C20.0344 17.136 20.7059 17.2187 21.3966 17.2187C22.0677 17.2187 22.7207 17.1406 23.3471 16.9928V26.3384C23.3471 27.8084 22.1664 29 20.7099 29H2.63727C1.18075 29 0 27.8084 0 26.3384V8.09909C0 6.62914 1.18074 5.4375 2.63726 5.4375H13.4553Z"
      fill="#2563EB"
    />
  </svg>
);

export default Branding;
