# Testing Canvas External JS

## Setup for Manual Testing with Nuxt Component Preview (via Custom Elements)

### 1. Launch Nuxt Component Preview Frontend

Clone and run the [nuxt-component-preview](https://github.com/drunomics/nuxt-component-preview) development playground:

```bash
git clone https://github.com/drunomics/nuxt-component-preview
cd nuxt-component-preview
npm install
npm run dev
```

The frontend will be available at `http://localhost:3000`.

### 2. Configure CORS

Copy the example CORS configuration from the nuxt-component-preview
README into your `nuxt.config.ts` - with your Drupal base URL.

### 3. Register Frontend as Preview Provider via Custom Elements

Install Custom Elements module, be sure to use the latest 3.x-dev
version. Then:

Create or update `sites/default/services.yml` (or your site-specific
services file) with the following configuration:

```yaml
parameters:
  custom_elements.nuxt_preview.base_url: 'http://localhost:3000'

services:
  custom_elements.preview_provider.nuxt:
    class: Drupal\custom_elements\Plugin\CustomElementsPreviewProvider\NuxtPreviewProvider
    factory: ['@plugin.manager.custom_elements_preview_provider', 'createInstance']
    arguments: ['nuxt']
    calls:
      - [setBaseUrl, ['%custom_elements.nuxt_preview.base_url%']]
    tags:
      - { name: custom_elements.preview_provider, priority: 100 }
```

Then clear Drupal cache:

```bash
ddev drush cr
```

Alternatively, Lupus Decoupled can be used, which takes care of providing
this services when the Nuxt preview provider is configured.

### 4. Register Components in Canvas

Register components from a component index file:

```bash
# Register from local fixture (for testing)
ddev drush canvas:extjs-register /var/www/html/web/modules/contrib/canvas_extjs/tests/fixtures/component-index.json

# Register from remote URL (production use)
ddev drush canvas:extjs-register https://yourfrontend.com/component-index.json
```

To unregister components:

```bash
ddev drush canvas:extjs-unregister /var/www/html/web/modules/contrib/canvas_extjs/tests/fixtures/component-index.json
```

### 5. Test in Canvas UI

1. Create a new Canvas page or edit an existing one
2. Add External JavaScript components to your page
3. During editing, Nuxt components should render correctly via the
   preview provider

## Testing JavaScript-bundle based rendering

The module comes with an example Javascript that can be used to test the
custom bundle-based rendering approach:

**1. Copy test fixture to public files:**
```bash
cp web/modules/contrib/canvas_extjs/tests/fixtures/test-components.js \
   web/sites/default/files/test-components.js
```

**2. Register components with JavaScript rendering:**
```bash
ddev drush canvas:extjs-register \
  modules/contrib/canvas_extjs/tests/fixtures/component-index.json \
  --javascript=/sites/default/files/test-components.js
```

**3. Test in Canvas:**
- Navigate to `/canvas`
- Create a new page
- Click "Add" to open component library
- Find "JS Components" category (contains registered components)
- Click "Test Button" to add it to the page
- Verify button renders in preview iframe with correct label and styling
- Components render using JavaScript bundle instead of custom_elements preview

**Expected Results:**
- Test Button renders as `<button class="test-button test-button--primary">Submit</button>`
- Props (label, variant, size) apply correctly
- JavaScript bundle loaded from `/sites/default/files/test-components.js`
- No custom_elements preview provider needed

## Component Management Commands

### Register Components from Component Index

The recommended way to register components is using a component index file:

```bash
# Register from local file
ddev drush canvas:extjs-register /path/to/component-index.json

# Register from remote URL
ddev drush canvas:extjs-register https://yourfrontend.com/component-index.json

# Using alias
ddev drush cxr https://yourfrontend.com/component-index.json
```

The component index contains metadata for multiple components. See [tests/fixtures/component-index.json](tests/fixtures/component-index.json) for an example.

**Components created:**
- `extjs.test_button` - Button with label, variant, size, and disabled props
- `extjs.test_card` - Card with title and description props
- `extjs.two_column_layout` - Two column layout with width prop and two slots (column-one, column-two)
- `extjs.test_popover` - Popover with placement, trigger, offset, and arrow props
- `extjs.test_markup` - Markup component with content prop

Note: Component IDs use snake_case (lowercase with underscores) to comply with Drupal machine name conventions.

### Unregister Components

To remove all components registered from a specific source:

```bash
# Unregister by source URL/path
ddev drush canvas:extjs-unregister https://yourfrontend.com/component-index.json

# Using alias
ddev drush cxu /path/to/component-index.json
```

This only removes components that were registered from the specified source.

### Development: Manual Component Management

Create test components using PHP (deprecated, use component index instead):

```bash
ddev drush php:eval "\Drupal\canvas_extjs\Plugin\Canvas\ComponentSource\ExternalJavaScriptComponent::createTestComponentEntities();"
```

Delete all extjs components:

```bash
ddev drush php:eval "\$storage = \Drupal::entityTypeManager()->getStorage('component'); \$entities = \$storage->loadByProperties(['source' => 'extjs']); \$storage->delete(\$entities);"
```

Delete a specific component:

```bash
ddev drush entity:delete component extjs.test_button
```
