<?php

declare(strict_types=1);

namespace Drupal\canvas_extjs;

use Symfony\Component\Serializer\NameConverter\CamelCaseToSnakeCaseNameConverter;

/**
 * Provides CamelCase/snake_case conversion functionality.
 *
 * Uses Symfony's name converter to convert between CamelCase and snake_case
 * for proper Drupal machine name compliance.
 */
trait CamelCaseSnakeCaseConverterTrait {

  /**
   * Converts a CamelCase name to snake_case.
   *
   * @param string $name
   *   The CamelCase name to convert.
   *
   * @return string
   *   The snake_case version of the name.
   */
  protected static function convertToSnakeCase(string $name): string {
    return (new CamelCaseToSnakeCaseNameConverter())->normalize($name);
  }

}
